\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{smathjsty}
\newif\if@usedhucs\@usedhucsfalse
\DeclareOption{dhucs}{\@usedhucstrue}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{amsart}}
\ProcessOptions\relax
\LoadClass[12pt,twoside,leqno]{amsart}
\linespread{1.6}
\usepackage{mathptmx}
\setlength{\textheight}{23cm} \setlength{\textwidth}{16cm}
\setlength{\oddsidemargin}{0cm} \setlength{\evensidemargin}{0cm}
\setlength{\topmargin}{0cm}
\usepackage{amssymb, amsmath, amsthm, enumerate}
\usepackage{graphicx}
\usepackage{url}
\def \CopyrightInfo  {\noindent Copyright \copyright~2025 the authors. This is an open access article distributed under the Creative Commons Attribution License,
which permits unrestricted use, distribution, and reproduction in any medium, provided the original work is properly cited. }
\def \ConflictofInterests {\section*{Conflict of Interests} \noindent The author(s)  declare  that there is no conflict of interests.}
\newcommand{\DateofSubmission}[1]{\gdef\@DateofSubmission{#1}}
\newcommand{\EmailofCorrespondingAuthor}[1]{\gdef\@EmailofCorrespondingAuthor{#1}}
\def \FootNoteInfo {\renewcommand{\thefootnote}{}\footnotetext{ $^*$Corresponding author\par E-mail address: \@EmailofCorrespondingAuthor \par Received \@DateofSubmission}}

\makeatletter
\renewcommand{\@secnumfont}{\large\bfseries}
\def\specialsection{\@startsection{section}{1}%
  \z@{\linespacing\@plus\linespacing}{.5\linespacing}%
%  {\normalfont\centering}}% DELETED
  {\normalfont}}% NEW
\def\section{\@startsection{section}{1}%
  \z@{.7\linespacing\@plus\linespacing}{.5\linespacing}%
%  {\normalfont\scshape\centering}}% DELETED
  {\normalfont\scshape}}% NEW
\makeatother


\makeatletter
\def\specialsection{\@startsection{section}{1}%
  \z@{\linespacing\@plus\linespacing}{.5\linespacing}%
%  {\normalfont\centering}}% DELETED
  {\normalfont}}% NEW
\def\section{\@startsection{section}{1}%
  \z@{.7\linespacing\@plus\linespacing}{.5\linespacing}%
%  {\normalfont\scshape\centering}}% DELETED
  {\normalfont\scshape\bfseries}}% NEW
\makeatother

